package(default_visibility = ["//visibility:public"])

exports_files(glob([
    "**/*",
]))

# rules_perl expects all files as src entry, this does prevent us using
# $(execpath) which is why we have another filegroup that uses this as
# data dep.
filegroup(
    name = "perl_runtime",
    srcs = [
        ":bin/perl",
        ":bin/xsubpp",
    ] + glob([
        "lib/perl5/**",
    ]),
)

filegroup(
    name = "perl",
    srcs = [
        ":bin/perl",
    ],
    data = [
        ":perl_runtime",
    ],
)

filegroup(
    name = "bison",
    srcs = [
        ":bin/bison",
    ],
    data = glob([
        "share/bison/**",
    ]),
)

filegroup(
    name = "qemu-kvm",
    srcs = [
        ":bin/qemu-kvm",
    ],
    data = glob([
        "share/qemu-firmware/**",
        "share/qemu/**",
    ]),
)

filegroup(
    name = "busybox",
    srcs = [
        ":bin/busybox",
    ],
    data = [
        ":bin/[",
        ":bin/[[",
        ":bin/acpid",
        ":bin/add-shell",
        ":bin/addgroup",
        ":bin/adduser",
        ":bin/adjtimex",
        ":bin/arch",
        ":bin/arp",
        ":bin/arping",
        ":bin/ascii",
        ":bin/ash",
        ":bin/awk",
        ":bin/base32",
        ":bin/base64",
        ":bin/basename",
        ":bin/bc",
        ":bin/beep",
        ":bin/blkdiscard",
        ":bin/blkid",
        ":bin/blockdev",
        ":bin/bootchartd",
        ":bin/brctl",
        ":bin/bunzip2",
        ":bin/busybox",
        ":bin/bzcat",
        ":bin/bzip2",
        ":bin/cal",
        ":bin/cat",
        ":bin/chat",
        ":bin/chattr",
        ":bin/chgrp",
        ":bin/chmod",
        ":bin/chown",
        ":bin/chpasswd",
        ":bin/chpst",
        ":bin/chroot",
        ":bin/chrt",
        ":bin/chvt",
        ":bin/cksum",
        ":bin/clear",
        ":bin/cmp",
        ":bin/comm",
        ":bin/conspy",
        ":bin/cp",
        ":bin/cpio",
        ":bin/crc32",
        ":bin/crond",
        ":bin/crontab",
        ":bin/cryptpw",
        ":bin/cttyhack",
        ":bin/cut",
        ":bin/date",
        ":bin/dc",
        ":bin/dd",
        ":bin/deallocvt",
        ":bin/delgroup",
        ":bin/deluser",
        ":bin/depmod",
        ":bin/devmem",
        ":bin/df",
        ":bin/dhcprelay",
        ":bin/diff",
        ":bin/dirname",
        ":bin/dmesg",
        ":bin/dnsd",
        ":bin/dnsdomainname",
        ":bin/dos2unix",
        ":bin/dpkg",
        ":bin/dpkg-deb",
        ":bin/du",
        ":bin/dumpkmap",
        ":bin/dumpleases",
        ":bin/echo",
        ":bin/ed",
        ":bin/egrep",
        ":bin/eject",
        ":bin/env",
        ":bin/envdir",
        ":bin/envuidgid",
        ":bin/ether-wake",
        ":bin/expand",
        ":bin/expr",
        ":bin/factor",
        ":bin/fakeidentd",
        ":bin/fallocate",
        ":bin/false",
        ":bin/fatattr",
        ":bin/fbset",
        ":bin/fbsplash",
        ":bin/fdflush",
        ":bin/fdformat",
        ":bin/fdisk",
        ":bin/fgconsole",
        ":bin/fgrep",
        ":bin/find",
        ":bin/findfs",
        ":bin/flock",
        ":bin/fold",
        ":bin/free",
        ":bin/freeramdisk",
        ":bin/fsck",
        ":bin/fsck.minix",
        ":bin/fsfreeze",
        ":bin/fstrim",
        ":bin/fsync",
        ":bin/ftpd",
        ":bin/ftpget",
        ":bin/ftpput",
        ":bin/fuser",
        ":bin/getopt",
        ":bin/getty",
        ":bin/grep",
        ":bin/groups",
        ":bin/gunzip",
        ":bin/gzip",
        ":bin/halt",
        ":bin/hd",
        ":bin/hdparm",
        ":bin/head",
        ":bin/hexdump",
        ":bin/hexedit",
        ":bin/hostid",
        ":bin/hostname",
        ":bin/httpd",
        ":bin/hush",
        ":bin/hwclock",
        ":bin/i2cdetect",
        ":bin/i2cdump",
        ":bin/i2cget",
        ":bin/i2cset",
        ":bin/i2ctransfer",
        ":bin/id",
        ":bin/ifconfig",
        ":bin/ifdown",
        ":bin/ifenslave",
        ":bin/ifplugd",
        ":bin/ifup",
        ":bin/inetd",
        ":bin/init",
        ":bin/insmod",
        ":bin/install",
        ":bin/ionice",
        ":bin/iostat",
        ":bin/ip",
        ":bin/ipaddr",
        ":bin/ipcalc",
        ":bin/ipcrm",
        ":bin/ipcs",
        ":bin/iplink",
        ":bin/ipneigh",
        ":bin/iproute",
        ":bin/iprule",
        ":bin/iptunnel",
        ":bin/kbd_mode",
        ":bin/kill",
        ":bin/killall",
        ":bin/killall5",
        ":bin/klogd",
        ":bin/less",
        ":bin/link",
        ":bin/linux32",
        ":bin/linux64",
        ":bin/ln",
        ":bin/loadfont",
        ":bin/loadkmap",
        ":bin/logger",
        ":bin/login",
        ":bin/logname",
        ":bin/logread",
        ":bin/losetup",
        ":bin/lpd",
        ":bin/lpq",
        ":bin/lpr",
        ":bin/ls",
        ":bin/lsattr",
        ":bin/lsmod",
        ":bin/lsof",
        ":bin/lspci",
        ":bin/lsscsi",
        ":bin/lsusb",
        ":bin/lzcat",
        ":bin/lzma",
        ":bin/lzop",
        ":bin/makedevs",
        ":bin/makemime",
        ":bin/man",
        ":bin/md5sum",
        ":bin/mdev",
        ":bin/mesg",
        ":bin/microcom",
        ":bin/mim",
        ":bin/mkdir",
        ":bin/mkdosfs",
        ":bin/mke2fs",
        ":bin/mkfifo",
        ":bin/mkfs.ext2",
        ":bin/mkfs.minix",
        ":bin/mkfs.vfat",
        ":bin/mknod",
        ":bin/mkpasswd",
        ":bin/mkswap",
        ":bin/mktemp",
        ":bin/modinfo",
        ":bin/modprobe",
        ":bin/more",
        ":bin/mount",
        ":bin/mountpoint",
        ":bin/mpstat",
        ":bin/mt",
        ":bin/mv",
        ":bin/nameif",
        ":bin/nanddump",
        ":bin/nandwrite",
        ":bin/nbd-client",
        ":bin/nc",
        ":bin/netstat",
        ":bin/nice",
        ":bin/nl",
        ":bin/nmeter",
        ":bin/nohup",
        ":bin/nologin",
        ":bin/nproc",
        ":bin/nsenter",
        ":bin/nslookup",
        ":bin/ntpd",
        ":bin/od",
        ":bin/openvt",
        ":bin/partprobe",
        ":bin/passwd",
        ":bin/paste",
        ":bin/patch",
        ":bin/pgrep",
        ":bin/pidof",
        ":bin/ping",
        ":bin/ping6",
        ":bin/pipe_progress",
        ":bin/pivot_root",
        ":bin/pkill",
        ":bin/pmap",
        ":bin/popmaildir",
        ":bin/poweroff",
        ":bin/powertop",
        ":bin/printenv",
        ":bin/printf",
        ":bin/ps",
        ":bin/pscan",
        ":bin/pstree",
        ":bin/pwd",
        ":bin/pwdx",
        ":bin/raidautorun",
        ":bin/rdate",
        ":bin/rdev",
        ":bin/readahead",
        ":bin/readlink",
        ":bin/readprofile",
        ":bin/realpath",
        ":bin/reboot",
        ":bin/reformime",
        ":bin/remove-shell",
        ":bin/renice",
        ":bin/reset",
        ":bin/resize",
        ":bin/resume",
        ":bin/rev",
        ":bin/rm",
        ":bin/rmdir",
        ":bin/rmmod",
        ":bin/route",
        ":bin/rpm",
        ":bin/rpm2cpio",
        ":bin/rtcwake",
        ":bin/run-init",
        ":bin/run-parts",
        ":bin/runsv",
        ":bin/runsvdir",
        ":bin/rx",
        ":bin/script",
        ":bin/scriptreplay",
        ":bin/sed",
        ":bin/seedrng",
        ":bin/sendmail",
        ":bin/seq",
        ":bin/setarch",
        ":bin/setconsole",
        ":bin/setfattr",
        ":bin/setfont",
        ":bin/setkeycodes",
        ":bin/setlogcons",
        ":bin/setpriv",
        ":bin/setserial",
        ":bin/setsid",
        ":bin/setuidgid",
        ":bin/sh",
        ":bin/sha1sum",
        ":bin/sha3sum",
        ":bin/sha256sum",
        ":bin/sha512sum",
        ":bin/showkey",
        ":bin/shred",
        ":bin/shuf",
        ":bin/slattach",
        ":bin/sleep",
        ":bin/smemcap",
        ":bin/softlimit",
        ":bin/sort",
        ":bin/split",
        ":bin/ssl_client",
        ":bin/start-stop-daemon",
        ":bin/stat",
        ":bin/strings",
        ":bin/stty",
        ":bin/su",
        ":bin/sulogin",
        ":bin/sum",
        ":bin/sv",
        ":bin/svc",
        ":bin/svlogd",
        ":bin/svok",
        ":bin/swapoff",
        ":bin/swapon",
        ":bin/switch_root",
        ":bin/sync",
        ":bin/sysctl",
        ":bin/syslogd",
        ":bin/tac",
        ":bin/tail",
        ":bin/tar",
        ":bin/taskset",
        ":bin/tcpsvd",
        ":bin/tee",
        ":bin/telnet",
        ":bin/telnetd",
        ":bin/test",
        ":bin/tftp",
        ":bin/tftpd",
        ":bin/time",
        ":bin/timeout",
        ":bin/top",
        ":bin/touch",
        ":bin/tr",
        ":bin/traceroute",
        ":bin/traceroute6",
        ":bin/tree",
        ":bin/true",
        ":bin/truncate",
        ":bin/ts",
        ":bin/tsort",
        ":bin/tty",
        ":bin/ttysize",
        ":bin/tunctl",
        ":bin/ubiattach",
        ":bin/ubidetach",
        ":bin/ubimkvol",
        ":bin/ubirename",
        ":bin/ubirmvol",
        ":bin/ubirsvol",
        ":bin/ubiupdatevol",
        ":bin/udhcpc",
        ":bin/udhcpc6",
        ":bin/udhcpd",
        ":bin/udpsvd",
        ":bin/uevent",
        ":bin/umount",
        ":bin/uname",
        ":bin/unexpand",
        ":bin/uniq",
        ":bin/unix2dos",
        ":bin/unlink",
        ":bin/unlzma",
        ":bin/unshare",
        ":bin/unxz",
        ":bin/unzip",
        ":bin/uptime",
        ":bin/usleep",
        ":bin/uudecode",
        ":bin/uuencode",
        ":bin/vconfig",
        ":bin/vi",
        ":bin/vlock",
        ":bin/volname",
        ":bin/watch",
        ":bin/watchdog",
        ":bin/wc",
        ":bin/wget",
        ":bin/which",
        ":bin/whoami",
        ":bin/whois",
        ":bin/xargs",
        ":bin/xxd",
        ":bin/xz",
        ":bin/xzcat",
        ":bin/yes",
        ":bin/zcat",
        ":bin/zcip",
    ],
)
