// Copyright The Monogon Project Authors.
// SPDX-License-Identifier: Apache-2.0

package main

import (
	"flag"
	"fmt"
	"log"
	"maps"
	"os"
	"slices"
	"sort"

	"source.monogon.dev/build/analysis/staticcheck"
)

func main() {
	out := flag.String("out", "", "The output file to write the list to")
	flag.Parse()

	if *out == "" {
		log.Fatal("-out argument is required")
	}

	outFile, err := os.OpenFile(*out, os.O_CREATE|os.O_TRUNC|os.O_RDWR, 0655)
	if err != nil {
		log.Fatalf("failed opening file: %v", err)
	}
	defer outFile.Close()

	const fileHeader = "# Generated by //build/analysis/staticcheck/generate_analyzers\n# Do not modify!\n\nANALYZER_NAMES = [\n"
	fmt.Fprint(outFile, fileHeader)

	analyzerNames := slices.Collect(maps.Keys(staticcheck.Analyzers))
	sort.Strings(analyzerNames)

	for _, name := range analyzerNames {
		fmt.Fprintf(outFile, "    %q,\n", name)
	}

	const fileFooter = "]\n"
	fmt.Fprint(outFile, fileFooter)
}
